/*
 * Decompiled with CFR 0.152.
 */
package jade.content.frame;

import jade.content.frame.Frame;
import jade.content.frame.FrameException;
import jade.content.frame.OrderedFrame;
import jade.content.frame.QualifiedFrame;
import jade.core.AID;
import jade.util.leap.Iterator;
import jade.util.leap.Serializable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class LEAPFrameCodec
implements Serializable {
    public static final String NAME = "LEAP";
    private transient ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
    private transient DataOutputStream outStream = new DataOutputStream(this.outBuffer);
    private transient Vector stringReferences = new Vector();
    private static final byte STRING = 6;
    private static final byte BOOLEAN = 7;
    private static final byte INTEGER = 8;
    private static final byte FLOAT = 9;
    private static final byte DATE = 10;
    private static final byte BYTE_SEQUENCE = 11;
    private static final byte AGGREGATE = 1;
    private static final byte CONTENT_ELEMENT_LIST = 2;
    private static final byte OBJECT = 3;
    private static final byte ELEMENT = 4;
    private static final byte END = 5;
    private static final byte MODIFIER = 16;
    private static final byte UNMODIFIER = -17;

    public synchronized byte[] encode(Frame content) throws FrameException {
        if (content == null) {
            return null;
        }
        try {
            this.write(this.outStream, content);
            byte[] fe = this.outBuffer.toByteArray();
            return fe;
        }
        catch (FrameException fe) {
            throw fe;
        }
        catch (Throwable t) {
            throw new FrameException("Error encoding content", t);
        }
        finally {
            this.outBuffer.reset();
            this.stringReferences.removeAllElements();
        }
    }

    public synchronized Frame decode(byte[] content) throws FrameException {
        if (content == null || content.length == 0) {
            return null;
        }
        ByteArrayInputStream inpBuffer = null;
        FilterInputStream inpStream = null;
        try {
            inpBuffer = new ByteArrayInputStream(content);
            inpStream = new DataInputStream(inpBuffer);
            Frame frame = (Frame)this.read((DataInputStream)inpStream);
            return frame;
        }
        catch (FrameException fe) {
            throw fe;
        }
        catch (Throwable t) {
            throw new FrameException("Error decoding content", t);
        }
        finally {
            try {
                inpStream.close();
                inpBuffer.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            this.stringReferences.removeAllElements();
        }
    }

    private void write(DataOutputStream stream, Object obj) throws Throwable {
        if (obj instanceof String) {
            this.writeString(stream, (byte)6, (String)obj);
        } else if (obj instanceof Boolean) {
            stream.writeByte(7);
            stream.writeBoolean((Boolean)obj);
        } else if (obj instanceof Long) {
            stream.writeByte(8);
            stream.writeLong((Long)obj);
        } else if (obj instanceof Date) {
            stream.writeByte(10);
            stream.writeLong(((Date)obj).getTime());
        } else if (obj instanceof byte[]) {
            stream.writeByte(11);
            byte[] b = (byte[])obj;
            stream.writeInt(b.length);
            stream.write(b, 0, b.length);
        } else if (obj instanceof OrderedFrame) {
            OrderedFrame f = (OrderedFrame)obj;
            int size = f.size();
            String typeName = f.getTypeName();
            if (typeName != null) {
                this.writeString(stream, (byte)1, typeName);
            } else {
                stream.writeByte(2);
            }
            int i = 0;
            while (i < size) {
                stream.writeByte(4);
                this.write(stream, f.elementAt(i));
                ++i;
            }
            stream.writeByte(5);
        } else if (obj instanceof QualifiedFrame) {
            QualifiedFrame f = (QualifiedFrame)obj;
            this.writeString(stream, (byte)3, f.getTypeName());
            Enumeration e = f.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                this.writeString(stream, (byte)4, key);
                this.write(stream, f.get(key));
            }
            stream.writeByte(5);
        } else if (obj instanceof AID) {
            this.write(stream, this.aidToFrame((AID)obj));
        } else {
            throw new FrameException("Object " + obj + " cannot be encoded");
        }
    }

    private Object read(DataInputStream stream) throws Throwable {
        Object obj = null;
        byte type = stream.readByte();
        if ((type & 0xFFFFFFEF) == 6) {
            obj = this.readString(stream, type);
        } else if (type == 7) {
            obj = new Boolean(stream.readBoolean());
        } else if (type == 8) {
            obj = new Long(stream.readLong());
        } else if (type == 10) {
            obj = new Date(stream.readLong());
        } else if (type == 11) {
            int length = stream.readInt();
            obj = new byte[length];
            stream.read((byte[])obj, 0, length);
        } else if ((type & 0xFFFFFFEF) == 1) {
            String typeName = this.readString(stream, type);
            OrderedFrame f = new OrderedFrame(typeName);
            this.fillOrderedFrame(stream, f);
            obj = f;
        } else if (type == 2) {
            OrderedFrame f = new OrderedFrame(null);
            this.fillOrderedFrame(stream, f);
            obj = f;
        } else if ((type & 0xFFFFFFEF) == 3) {
            String typeName = this.readString(stream, type);
            QualifiedFrame f = new QualifiedFrame(typeName);
            byte marker = stream.readByte();
            do {
                if ((marker & 0xFFFFFFEF) != 4) continue;
                String elementName = this.readString(stream, marker);
                Object elementVal = this.read(stream);
                f.put(elementName, elementVal);
                marker = stream.readByte();
            } while (marker != 5);
            obj = f.getTypeName().equals("agent-identifier") ? this.frameToAid(f) : f;
        } else {
            throw new FrameException("Unexpected tag " + type);
        }
        return obj;
    }

    private void fillOrderedFrame(DataInputStream stream, OrderedFrame f) throws Throwable {
        byte marker = stream.readByte();
        do {
            if (marker != 4) continue;
            Object elementVal = this.read(stream);
            f.addElement(elementVal);
            marker = stream.readByte();
        } while (marker != 5);
    }

    private final void writeString(DataOutputStream stream, byte tag, String s) throws Throwable {
        int index = this.stringReferences.indexOf(s);
        if (index >= 0) {
            stream.writeByte(tag | 0x10);
            stream.writeByte(index);
        } else {
            stream.writeByte(tag);
            stream.writeUTF(s);
            if (s.length() > 1 && this.stringReferences.size() < 256) {
                this.stringReferences.addElement(s);
            }
        }
    }

    private final String readString(DataInputStream stream, byte tag) throws Throwable {
        if ((tag & 0x10) != 0) {
            int index = stream.readUnsignedByte();
            String s = (String)this.stringReferences.elementAt(index);
            return s;
        }
        String s = stream.readUTF();
        if (s.length() > 1 && this.stringReferences.size() < 256) {
            this.stringReferences.addElement(s);
        }
        return s;
    }

    private final QualifiedFrame aidToFrame(AID id) {
        QualifiedFrame f = new QualifiedFrame("agent-identifier");
        f.put("name", id.getName());
        Iterator i = id.getAllAddresses();
        if (i.hasNext()) {
            OrderedFrame addresses = new OrderedFrame("sequence");
            while (i.hasNext()) {
                addresses.addElement(i.next());
            }
            f.put("addresses", addresses);
        }
        if ((i = id.getAllResolvers()).hasNext()) {
            OrderedFrame resolvers = new OrderedFrame("sequence");
            while (i.hasNext()) {
                AID res = (AID)i.next();
                resolvers.addElement(this.aidToFrame(res));
            }
            f.put("resolvers", resolvers);
        }
        return f;
    }

    private final AID frameToAid(QualifiedFrame f) {
        OrderedFrame resolvers;
        AID id = new AID((String)f.get("name"), true);
        OrderedFrame addresses = (OrderedFrame)f.get("addresses");
        if (addresses != null) {
            int i = 0;
            while (i < addresses.size()) {
                id.addAddresses((String)addresses.elementAt(i));
                ++i;
            }
        }
        if ((resolvers = (OrderedFrame)f.get("resolvers")) != null) {
            int i = 0;
            while (i < resolvers.size()) {
                AID res = this.frameToAid((QualifiedFrame)resolvers.elementAt(i));
                id.addResolvers(res);
                ++i;
            }
        }
        return id;
    }
}

